/************************************************************************
 * NAME:	fat.c
 *
 * DESCR:	Implements the CoCo file allocation table.
 *
 *
 * NOTES:	
 ************************************************************************/
#include "coco.h"
#include "fat.h"

/************************************************************************
 * NAME:	coco_fat_read() & coco_fat_write()
 *
 * DESCR:	Reads/writes the FAT into/out-of the FAT sector.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
coco_fat_read(struct cocofs *cocofs)
{
    if (!coco_getpsect(cocofs,COCO_FAT_TRACK,COCO_FAT_SECTOR,cocofs->FAT)) {
	return(FALSE);
    }

    return(TRUE);
}

int
coco_fat_write(struct cocofs *cocofs)
{
    if (!coco_putpsect(cocofs,COCO_FAT_TRACK,COCO_FAT_SECTOR,cocofs->FAT)) {
	return(FALSE);
    }

    return(TRUE);
}

/************************************************************************
 * NAME:	coco_fat_gran_link()
 *
 * DESCR:	Link one gran to another.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
void
coco_fat_gran_link(struct cocofs *cocofs, int from, int to)
{
    cocofs->FAT[from] = to;
}

/************************************************************************
 * NAME:	coco_fat_gran_alloc()
 *
 * DESCR:	Returns a free gran from the FAT 
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
coco_fat_gran_alloc(struct cocofs *cocofs)
{
    int	g;

    for (g=0; g < COCO_TOTAL_GRANS; g++) {
	if (COCO_GRAN_FREE(cocofs,g)) {
	    coco_fat_gran_link(cocofs,g,g);	/* temporary link	*/
	    return(g);
	}
    }

    return(COCO_NULL_GRAN);	/* none left!	*/
}

/************************************************************************
 * NAME:	coco_fat_free_grans()
 *
 * DESCR:	Returns a count of the number of free grans.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
coco_fat_free_grans(struct cocofs *cocofs)
{
    int	g;
    int	count = 0;

    for (g=0; g < COCO_TOTAL_GRANS; g++) {
	if (COCO_GRAN_FREE(cocofs,g)) {
	    count++;
	}
    }

    return(count);
}

/************************************************************************
 * NAME:	coco_fat_free_bytes	()
 *
 * DESCR:	Returns the number of free bytes in the FAT.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
coco_fat_free_bytes(struct cocofs *cocofs)
{
    return(coco_fat_free_bytes(cocofs)*COCO_SECTORS_PER_GRAN*COCO_SECTOR_SIZE);
}

/************************************************************************
 * NAME:	coco_fat_free_chain()
 *
 * DESCR:	Frees the chain of grans provided.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
coco_fat_free_chain(struct cocofs *cocofs, int firstgran)
{
    int	g;
    int	nextgran;

    for ( g = firstgran; !COCO_FAT_LAST_GRAN(cocofs,g); g = nextgran) {
	nextgran = cocofs->FAT[g];
	cocofs->FAT[g] = COCO_FAT_FREE;
    }
}

/************************************************************************
 * NAME:	coco_fat_last_sectors()
 *
 * DESCR:	Given the last gran and the numbers of sectors used
 *		within it, update the FAT.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/

coco_fat_last_sectors(struct cocofs *cocofs, int lastgran, int sectors)
{
    cocofs->FAT[lastgran] = 0xC0 | sectors;
}
